<?php

namespace App\Controller\Domain\backend;

use App\Entity\Service;
use App\Form\ServiceType;
use App\Helpers\Utility;
use App\Repository\ServiceRepository;
use Doctrine\ORM\EntityManagerInterface;
use Symfony\Bundle\FrameworkBundle\Controller\AbstractController;
use Symfony\Component\HttpFoundation\Request;
use Symfony\Component\HttpFoundation\Response;
use Symfony\Component\Routing\Attribute\Route;

#[Route('/admin/service', name: 'back.service.')]
final class ServiceController extends AbstractController
{
    private string $basePath = "uploads/images/services/";

    #[Route(name: 'index', methods: ['GET'])]
    public function index(ServiceRepository $serviceRepository): Response
    {
        return $this->render('domain/backend/service/index.html.twig', [
            'services' => $serviceRepository->findAll(),
        ]);
    }

    #[Route('/new', name: 'new', methods: ['GET', 'POST'])]
    public function new(Request $request, EntityManagerInterface $entityManager): Response
    {
        $service = new Service();
        $form = $this->createForm(ServiceType::class, $service);
        $form->handleRequest($request);

        if ($form->isSubmitted() && $form->isValid()) {
            $imageFile = $form->get('image')->getData();
            $fileStored = Utility::uploadFile($imageFile, $this->getParameter('images_directory'), "services",512, 512);
            if ($fileStored) {
                $service->setImage($this->basePath .$fileStored);
            }
            $entityManager->persist($service);
            $entityManager->flush();

            return $this->redirectToRoute('back.service.index', [], Response::HTTP_SEE_OTHER);
        }

        return $this->render('domain/backend/service/new.html.twig', [
            'service' => $service,
            'form' => $form,
        ]);
    }

    #[Route('/{id}', name: 'show', methods: ['GET'])]
    public function show(Service $service): Response
    {
        return $this->render('domain/backend/service/show.html.twig', [
            'service' => $service,
        ]);
    }

    #[Route('/{id}/edit', name: 'edit', methods: ['GET', 'POST'])]
    public function edit(Request $request, Service $service, EntityManagerInterface $entityManager): Response
    {
        $oldImage = $service->getImage();
        $form = $this->createForm(ServiceType::class, $service);
        $form->handleRequest($request);


        if ($form->isSubmitted() && $form->isValid()) {
            $imageFile = $form->get('image')->getData();
            $fileStored = Utility::uploadFile($imageFile, $this->getParameter('images_directory'), "services",512, 512);
            if ($fileStored) {
                // Suppression de l'ancienne image
                $path = $this->getParameter('images_directory') . '/services/' . basename($oldImage);
                if ($oldImage && file_exists($path)) {
                    unlink($path);
                }
                $service->setImage($this->basePath . $fileStored);
            }
            $entityManager->flush();

            return $this->redirectToRoute('back.service.index', [], Response::HTTP_SEE_OTHER);
        }

        return $this->render('domain/backend/service/edit.html.twig', [
            'service' => $service,
            'form' => $form,
        ]);
    }

    #[Route('/{id}', name: 'delete', methods: ['POST'])]
    public function delete(Request $request, Service $service, EntityManagerInterface $entityManager): Response
    {
        if ($this->isCsrfTokenValid('delete'.$service->getId(), $request->getPayload()->getString('_token'))) {

            $image = $service->getImage();
            if ($image) {
                $path = $this->getParameter('images_directory') . '/services/' . basename($image);
                if (file_exists($path)) {
                    unlink($path);
                }
            }
            $entityManager->remove($service);
            $entityManager->flush();
        }

        return $this->redirectToRoute('back.service.index', [], Response::HTTP_SEE_OTHER);
    }
}
