<?php

namespace App\EventSubscriber;

use App\Service\SlugService;
use Symfony\Component\EventDispatcher\EventSubscriberInterface;
use Doctrine\ORM\Events;
use Doctrine\Persistence\Event\LifecycleEventArgs;

readonly class SlugSubscriber implements EventSubscriberInterface
{
//    public function __construct(
//        private SlugService $slugService
//    ) {
//    }

    public static function getSubscribedEvents(): array
    {
        return [
            Events::prePersist,
            Events::preUpdate,
        ];
    }

    public function prePersist($args): void
    {
        $this->handleSlug($args);
    }

    public function preUpdate($args): void
    {
        $this->handleSlug($args);
    }

    private function handleSlug($args): void
    {

        $entity = $args;
        if (method_exists($entity, 'getSlugSource') && method_exists($entity, 'setSlug')) {
            $slugService = new SlugService();
            $slugService->updateSlug($entity);
        }
    }
}