<?php

namespace App\Form;

use App\Entity\Category;
use App\Entity\Post;
use App\Entity\Tag;
use Symfony\Bridge\Doctrine\Form\Type\EntityType;
use Symfony\Component\Form\AbstractType;
use Symfony\Component\Form\Extension\Core\Type\CheckboxType;
use Symfony\Component\Form\Extension\Core\Type\CollectionType;
use Symfony\Component\Form\Extension\Core\Type\DateType;
use Symfony\Component\Form\Extension\Core\Type\FileType;
use Symfony\Component\Form\Extension\Core\Type\TextareaType;
use Symfony\Component\Form\FormBuilderInterface;
use Symfony\Component\OptionsResolver\OptionsResolver;
use Symfony\Component\Validator\Constraints\File;

class PostType extends AbstractType
{
    public function buildForm(FormBuilderInterface $builder, array $options): void
    {
        $builder
            ->add('titre')
            ->add('contenu', TextareaType::class, [
                'attr' => [
                    'rows' => 10,
                    'class' => 'ckeditor-editor',
                ]
            ])

            ->add('imageCouverture', FileType::class, [
                'mapped' => false,
                'required' => false,
                'constraints' => [
                    new  File()
                ]
            ])
            ->add('datePublication', DateType::class, [
                'widget' => 'single_text',
            ])
            ->add('category', EntityType::class, [
                'class' => Category::class,
                'choice_label' => 'nom',
                'choice_value' => 'id',
                'attr' => [
                ],
                'placeholder' => 'Choisir une catégorie...'
            ])
            ->add('tags', EntityType::class, [
                'class' => Tag::class,
                'choice_label' => 'libelle',
                'choice_value' => 'id',
                'multiple' => true,
                'attr' => [
                    'class' => 'select'
                ]
            ])
            ->add('showHome', CheckboxType::class, [
                'label' => "Afficher sur la page d'accueil",
                'required' => false,
            ])
            ->add('postMedia', CollectionType::class, [
                'entry_type' => PostMediaType::class,
                'allow_add' => true,
                'allow_delete' => true,
                'by_reference' => true,
                'prototype' => true,
                'label' => false,
            ])
        ;
    }

    public function configureOptions(OptionsResolver $resolver): void
    {
        $resolver->setDefaults([
            'data_class' => Post::class,
        ]);
    }
}
