<?php

namespace App\Helpers;

use Imagine\Gd\Imagine;
use Imagine\Image\Box;
use InvalidArgumentException;
use Symfony\Component\HttpFoundation\File\UploadedFile;

class Utility
{


    private static function verifierRatioImage(int $largeur, int $hauteur, float $ratio, float $tolerance = 0.01): bool
    {
        if ($hauteur === 0) {
            throw new InvalidArgumentException("La hauteur ne peut pas être zéro.");
        }

        $ratioCalcule = $largeur / $hauteur;
        return abs($ratioCalcule - $ratio) <= $tolerance;
    }

    static function uploadFile($imageFile, $dirParam, $repName, $width = null, $height = null): string|bool
    {
        if ($imageFile instanceof UploadedFile) {
            $imagePath = $imageFile->getRealPath();
            list($largeur, $hauteur) = getimagesize($imagePath);
            $hasAcceptableRatio = self::verifierRatioImage($largeur, $hauteur, 2.14);

            // Générer un nom unique pour l'image
            $originalFilename = pathinfo($imageFile->getClientOriginalName(), PATHINFO_FILENAME);
            $safeFilename = transliterator_transliterate('Any-Latin; Latin-ASCII', $originalFilename);
            $safeFilename = str_replace(['\'', '"', ' '], '-', $safeFilename);
            $newFilename = $safeFilename . '-' . uniqid() . '.' . $imageFile->guessExtension();

            $rep = strtolower($dirParam . "/" . $repName);
            $fullPath = $rep . '/' . $newFilename;

            // Déplacer le fichier
            $imageFile->move($rep, $newFilename);

            // Redimensionner l'image si les dimensions sont spécifiées
            if ($width !== null || $height !== null) {
                if ($hasAcceptableRatio !== true) {
                    $imagine = new Imagine();
                    $image = $imagine->open($fullPath);

                    // Obtenir les dimensions originales
                    $size = $image->getSize();
                    $origWidth = $size->getWidth();
                    $origHeight = $size->getHeight();

                    // Calculer les nouvelles dimensions en conservant le ratio
                    if ($width && $height) {
                        $newWidth = $width;
                        $newHeight = $height;
                    } elseif ($width) {
                        $ratio = $width / $origWidth;
                        $newWidth = $width;
                        $newHeight = (int)($origHeight * $ratio);
                    } else {
                        $ratio = $height / $origHeight;
                        $newHeight = $height;
                        $newWidth = (int)($origWidth * $ratio);
                    }

                    // Redimensionner et sauvegarder
                    $image->resize(new Box($newWidth, $newHeight))
                        ->save($fullPath);
                }
            }

            return $newFilename;
        }

        return false;
    }

    static function uploadFileNoImage($file, $dirParam, $repName): string|bool
    {
        if ($file instanceof UploadedFile) {
            // Vérifier l'extension du fichier pour s'assurer qu'il s'agit bien d'un PDF ou Word
            $allowedExtensions = ['pdf', 'doc', 'docx'];
            $fileExtension = $file->guessExtension();

            if (!in_array($fileExtension, $allowedExtensions)) {
                return false; // Si le fichier n'est pas un PDF ou un fichier Word, on le refuse
            }

            // Générer un nom unique pour le fichier
            $originalFilename = pathinfo($file->getClientOriginalName(), PATHINFO_FILENAME);
            $safeFilename = transliterator_transliterate('Any-Latin; Latin-ASCII', $originalFilename);
            $safeFilename = str_replace(['\'', '"', ' '], '-', $safeFilename);
            $newFilename = $safeFilename . '-' . uniqid() . '.' . $fileExtension;

            // Définir le chemin du répertoire où le fichier sera stocké
            $rep = strtolower($dirParam . "/" . $repName);
            $fullPath = $rep . '/' . $newFilename;

            // Déplacer le fichier dans le répertoire souhaité
            $file->move($rep, $newFilename);

            return $newFilename; // Retourner le nom du fichier enregistré
        }

        return false; // Si le fichier n'est pas une instance d'UploadedFile, retourner false
    }
}