<?php

namespace App\Service;

use Imagine\Image\Box;
use Imagine\Gd\Imagine;
use Symfony\Component\HttpFoundation\File\UploadedFile;

class ImageResizer
{
    private string $uploadDirectory;

    public function __construct(string $uploadDirectory)
    {
        $this->uploadDirectory = $uploadDirectory;
    }

    public function resizeImage(UploadedFile $file, string $subDirectory, int $width, int $height): string
    {
        // Crée une instance de la bibliothèque Imagine
        $imagine = new Imagine();

        // Ouvre l'image téléchargée
        $image = $imagine->open($file->getPathname());

        // Redimensionne l'image
        $image->resize(new Box($width, $height));

        // Définir le répertoire spécifique pour l'entité
        $uploadDir = $this->uploadDirectory . '/' . $subDirectory;

        // Générez un nom de fichier unique pour l'image redimensionnée
        $filename = uniqid('image_') . '.' . $file->getClientOriginalExtension();

        // Sauvegarder l'image redimensionnée dans le répertoire
        $image->save($uploadDir . '/' . $filename);

        return $filename; // Retourner le nom du fichier redimensionné
    }
}