<?php

namespace App\Service;

use Symfony\Component\String\AbstractUnicodeString;
use Symfony\Component\String\Slugger\SluggerInterface;

readonly class SlugService
{

    public function generateSlug(array $text): string
    {
        return $this->slugify($text["slug"]);
    }

    public function updateSlug(object $entity)
    {
        if (!method_exists($entity, 'setSlug')) {
            throw new \InvalidArgumentException('Entity must implement setSlug method');
        }
        $slug = $this->generateSlug($entity->getSlugSource());


        return $entity->setSlug($slug);
    }

   private function slugify($str) {
        // Convertir en minuscules
        $str = strtolower($str);

        // Translitération pour les caractères accentués
        $str = iconv('UTF-8', 'ASCII//TRANSLIT', $str);

        // Remplacer les caractères non alphanumériques par des tirets
        $str = preg_replace('/[^a-z0-9]+/', '-', $str);

        // Supprimer les tirets en début et fin de chaîne
       return trim($str, '-');
    }
}