<?php

namespace App\Trait;

use App\Entity\Post;
use Doctrine\ORM\EntityManagerInterface;
use Doctrine\ORM\Mapping as ORM;
use App\Service\SlugService;
use Gedmo\Mapping\Annotation\Slug;
use JetBrains\PhpStorm\NoReturn;

#[ORM\HasLifecycleCallbacks]
trait SluggableTrait
{
    private EntityManagerInterface $entityManager;
    #[NoReturn] function __construct(EntityManagerInterface $entityManager)
    {
        $this->entityManager = $entityManager;
    }
    #[ORM\Column(length: 255, unique: true, nullable: true)]
    private ?string $slug = null;

    public function getSlug(): ?string
    {
        return $this->slug;
    }

    public function setSlug(?string $slug = null): void
    {
//        $object = $this;
//        $source = $this->getSlugSource();
        $this->slug = $slug;
    }

    public function getSlugSource(): array
    {
        // Retourne le champ de l'entité à utiliser pour générer le slug
        if (property_exists($this, 'titre')) {
            return [
                'name' => 'titre',
                'slug' => $this->titre,
            ];
        }
        if (property_exists($this, 'libelle')) {
            return [
                'name' => 'libelle',
                'slug' => $this->libelle,
            ];
        }
        if (property_exists($this, 'name')) {
            return [
                'name' => 'name',
                'slug' => $this->name,
            ];
        }
        if (property_exists($this, 'description')) {
            return [
                'name' => 'description',
                'slug' => $this->description,
            ];
        }
        throw new \LogicException('No slug source field found (titre, libelle, name, description)');
    }
}